# Conference Website MVP - Todo List

## Project: Intelligence and the Role of Higher Education in Enabling Digital Government Conference

### Core Features to Implement:
1. **Homepage** - Conference overview, dates, location
2. **About** - Conference theme and objectives
3. **Speakers** - Grid layout for 15 speakers with profiles
4. **Schedule** - 3-day conference program
5. **Paper Submission** - Form for speakers to submit papers
6. **Registration** - Attendee registration form
7. **Contact** - Contact information and venue details

### Files to Create:
1. `src/pages/Index.tsx` - Homepage (rewrite existing)
2. `src/pages/About.tsx` - About the conference
3. `src/pages/Speakers.tsx` - Speaker profiles
4. `src/pages/Schedule.tsx` - Conference schedule
5. `src/pages/PaperSubmission.tsx` - Paper submission form
6. `src/pages/Registration.tsx` - Registration form
7. `src/pages/Contact.tsx` - Contact information
8. `src/components/Navbar.tsx` - Navigation component

### Deployment Files:
1. `Dockerfile` - Container configuration
2. `docker-compose.yml` - Docker compose setup
3. `nginx.conf` - Nginx configuration
4. `deploy.sh` - Deployment script

### Theme: Professional Academic
- Colors: Deep blue, gold accents, white
- Modern, clean design
- Responsive layout
- Academic feel with professional typography