import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Target, Lightbulb, Globe, GraduationCap, Building, Users, Award, Briefcase } from 'lucide-react';

export default function About() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-slate-900 via-blue-900 to-gray-900 relative overflow-hidden">
      {/* Subtle background elements */}
      <div className="absolute inset-0 overflow-hidden">
        <div className="absolute top-20 left-10 w-32 h-32 bg-gradient-to-br from-blue-600 to-slate-700 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-pulse"></div>
        <div className="absolute bottom-20 right-10 w-40 h-40 bg-gradient-to-br from-slate-600 to-blue-800 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-pulse animation-delay-2000"></div>
        <div className="absolute top-1/2 left-1/3 w-24 h-24 bg-gradient-to-br from-gray-700 to-blue-700 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-pulse animation-delay-4000"></div>
      </div>

      <div className="relative py-12 px-4">
        <div className="max-w-6xl mx-auto">
          <div className="text-center mb-12">
            <div className="inline-flex items-center px-6 py-3 bg-gradient-to-r from-blue-600 to-slate-700 rounded-full text-white text-sm font-medium mb-8 shadow-lg">
              <Building className="w-4 h-4 mr-2" />
              Professional Conference
            </div>
            <h1 className="text-3xl md:text-5xl font-bold text-white mb-6 leading-tight">
              Artificial Intelligence and the Role of Higher Education in Enabling Digital Government
            </h1>
            <p className="text-xl text-gray-300 max-w-4xl mx-auto leading-relaxed">
              Exploring the transformative intersection of 
              <span className="text-blue-400 font-semibold"> artificial intelligence</span>, 
              <span className="text-slate-400 font-semibold"> higher education</span>, and 
              <span className="text-gray-400 font-semibold"> digital governance</span> for sustainable public sector innovation.
            </p>
          </div>

          {/* Conference Theme */}
          <section className="mb-16">
            <Card className="bg-white/5 backdrop-blur-md border border-white/10 hover:bg-white/8 transition-all duration-300 shadow-xl">
              <CardHeader className="text-center">
                <CardTitle className="text-3xl text-white flex items-center justify-center gap-3">
                  <Award className="w-8 h-8 text-blue-400" />
                  Conference Mission
                </CardTitle>
              </CardHeader>
              <CardContent className="text-center">
                <p className="text-lg text-gray-300 leading-relaxed">
                  In an era of rapid digital transformation, governments worldwide are leveraging artificial intelligence 
                  and partnering with higher education institutions to create more efficient, transparent, and citizen-centric 
                  public services. This conference brings together leading minds to explore how intelligent systems and 
                  academic expertise can drive the evolution of digital governance while ensuring ethical implementation 
                  and sustainable development.
                </p>
              </CardContent>
            </Card>
          </section>

          {/* Key Objectives */}
          <section className="mb-16">
            <h2 className="text-4xl font-bold text-center text-white mb-8">
              Key Objectives
            </h2>
            <div className="grid md:grid-cols-2 gap-8">
              <Card className="bg-gradient-to-br from-blue-600/10 to-blue-800/10 backdrop-blur-md border border-white/10 hover:scale-105 transition-all duration-300 group shadow-xl">
                <CardContent className="p-6">
                  <div className="flex items-start space-x-4">
                    <div className="w-12 h-12 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center flex-shrink-0 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                      <Target className="w-6 h-6 text-white" />
                    </div>
                    <div>
                      <h3 className="text-xl font-semibold text-white mb-2">Strategic Insights</h3>
                      <p className="text-gray-300">
                        Examine how AI technologies can enhance government decision-making processes and policy development frameworks.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="bg-gradient-to-br from-slate-600/10 to-slate-800/10 backdrop-blur-md border border-white/10 hover:scale-105 transition-all duration-300 group shadow-xl">
                <CardContent className="p-6">
                  <div className="flex items-start space-x-4">
                    <div className="w-12 h-12 bg-gradient-to-br from-slate-500 to-slate-600 rounded-lg flex items-center justify-center flex-shrink-0 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                      <Lightbulb className="w-6 h-6 text-white" />
                    </div>
                    <div>
                      <h3 className="text-xl font-semibold text-white mb-2">Innovation Showcase</h3>
                      <p className="text-gray-300">
                        Present cutting-edge research and practical applications of AI in public sector transformation initiatives.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="bg-gradient-to-br from-gray-600/10 to-gray-800/10 backdrop-blur-md border border-white/10 hover:scale-105 transition-all duration-300 group shadow-xl">
                <CardContent className="p-6">
                  <div className="flex items-start space-x-4">
                    <div className="w-12 h-12 bg-gradient-to-br from-gray-500 to-gray-600 rounded-lg flex items-center justify-center flex-shrink-0 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                      <Globe className="w-6 h-6 text-white" />
                    </div>
                    <div>
                      <h3 className="text-xl font-semibold text-white mb-2">Global Perspectives</h3>
                      <p className="text-gray-300">
                        Share international best practices and lessons learned from digital government initiatives across continents.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="bg-gradient-to-br from-blue-700/10 to-slate-700/10 backdrop-blur-md border border-white/10 hover:scale-105 transition-all duration-300 group shadow-xl">
                <CardContent className="p-6">
                  <div className="flex items-start space-x-4">
                    <div className="w-12 h-12 bg-gradient-to-br from-blue-600 to-slate-600 rounded-lg flex items-center justify-center flex-shrink-0 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                      <GraduationCap className="w-6 h-6 text-white" />
                    </div>
                    <div>
                      <h3 className="text-xl font-semibold text-white mb-2">Academic Collaboration</h3>
                      <p className="text-gray-300">
                        Foster strategic partnerships between universities and government agencies for sustainable digital transformation.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>
            </div>
          </section>

          {/* Topics */}
          <section>
            <h2 className="text-4xl font-bold text-center text-white mb-8">
              Conference Topics
            </h2>
            <Card className="bg-gradient-to-br from-slate-800/20 to-blue-800/20 backdrop-blur-md border border-white/10 shadow-xl">
              <CardContent className="p-8">
                <div className="grid md:grid-cols-2 gap-8">
                  <div className="space-y-6">
                    <div className="bg-white/5 rounded-xl p-6 hover:bg-white/10 transition-all duration-300 border border-white/10">
                      <h3 className="text-xl font-semibold text-blue-400 mb-4 flex items-center gap-2">
                        <Briefcase className="w-5 h-5" />
                        AI & Digital Governance
                      </h3>
                      <ul className="space-y-2 text-gray-300">
                        <li>• Machine Learning in Public Policy</li>
                        <li>• Predictive Analytics for Government</li>
                        <li>• AI Ethics in Public Sector</li>
                        <li>• Automated Decision Systems</li>
                      </ul>
                    </div>
                    
                    <div className="bg-white/5 rounded-xl p-6 hover:bg-white/10 transition-all duration-300 border border-white/10">
                      <h3 className="text-xl font-semibold text-slate-400 mb-4 flex items-center gap-2">
                        <GraduationCap className="w-5 h-5" />
                        Higher Education Role
                      </h3>
                      <ul className="space-y-2 text-gray-300">
                        <li>• University-Government Partnerships</li>
                        <li>• Research Translation to Policy</li>
                        <li>• Capacity Building Programs</li>
                        <li>• Digital Skills Development</li>
                      </ul>
                    </div>
                  </div>
                  
                  <div className="space-y-6">
                    <div className="bg-white/5 rounded-xl p-6 hover:bg-white/10 transition-all duration-300 border border-white/10">
                      <h3 className="text-xl font-semibold text-gray-400 mb-4 flex items-center gap-2">
                        <Building className="w-5 h-5" />
                        Digital Transformation
                      </h3>
                      <ul className="space-y-2 text-gray-300">
                        <li>• E-Government Services</li>
                        <li>• Digital Identity Systems</li>
                        <li>• Blockchain in Government</li>
                        <li>• Cybersecurity Frameworks</li>
                      </ul>
                    </div>
                    
                    <div className="bg-white/5 rounded-xl p-6 hover:bg-white/10 transition-all duration-300 border border-white/10">
                      <h3 className="text-xl font-semibold text-blue-300 mb-4 flex items-center gap-2">
                        <Users className="w-5 h-5" />
                        Future Perspectives
                      </h3>
                      <ul className="space-y-2 text-gray-300">
                        <li>• Smart Cities Development</li>
                        <li>• Citizen Engagement Platforms</li>
                        <li>• Data-Driven Governance</li>
                        <li>• Sustainable Digital Solutions</li>
                      </ul>
                    </div>
                  </div>
                </div>
              </CardContent>
            </Card>
          </section>
        </div>
      </div>
    </div>
  );
}