# IHEDG 2025 Conference Website - Deployment Guide

## 📦 Download & Deployment Instructions

### Quick Download
You can download all files by clicking the **"Export"** button in the Share menu (top-right corner of the platform).

## 🚀 Server Deployment Options

### Option 1: TMD Cloud VPS Deployment (Recommended)

#### Prerequisites
- TMD Cloud VPS server (2GB+ RAM, 20GB+ storage)
- Ubuntu 20.04+ or CentOS 8+
- Domain name pointed to your server IP

#### Step 1: Upload Files to Server
```bash
# Upload the exported files to your server
scp -r ihedg-conference-files/ user@your-server-ip:/opt/
```

#### Step 2: Run TMD Cloud Deployment
```bash
# SSH into your server
ssh user@your-server-ip

# Navigate to project directory
cd /opt/ihedg-conference-files/

# Make deployment script executable
chmod +x deploy-tmd.sh

# Run TMD Cloud deployment
DOMAIN=your-domain.com EMAIL=your-email@domain.com ./deploy-tmd.sh
```

#### Step 3: Access Your Website
- HTTP: `http://your-server-ip`
- HTTPS: `https://your-domain.com` (after SSL setup)
- Monitor: `http://your-server-ip:8080`

### Option 2: Standard VPS Deployment

#### Step 1: Server Preparation
```bash
# Update system
sudo apt update && sudo apt upgrade -y

# Install Docker
curl -fsSL https://get.docker.com -o get-docker.sh
sudo sh get-docker.sh
sudo usermod -aG docker $USER

# Install Docker Compose
sudo curl -L "https://github.com/docker/compose/releases/latest/download/docker-compose-$(uname -s)-$(uname -m)" -o /usr/local/bin/docker-compose
sudo chmod +x /usr/local/bin/docker-compose

# Logout and login again for docker group to take effect
```

#### Step 2: Deploy Application
```bash
# Navigate to project directory
cd /path/to/your/project

# Build and start containers
docker-compose build
docker-compose up -d

# Check status
docker-compose ps
```

### Option 3: Manual Deployment (Without Docker)

#### Prerequisites
- Node.js 18+ and npm/pnpm
- Nginx web server

#### Step 1: Build the Application
```bash
# Install dependencies
pnpm install

# Build for production
pnpm run build
```

#### Step 2: Configure Nginx
```bash
# Copy built files to web directory
sudo cp -r dist/* /var/www/html/

# Configure nginx (create /etc/nginx/sites-available/ihedg-conference)
server {
    listen 80;
    server_name your-domain.com;
    root /var/www/html;
    index index.html;

    location / {
        try_files $uri $uri/ /index.html;
    }

    # Cache static assets
    location ~* \.(js|css|png|jpg|jpeg|gif|ico|svg)$ {
        expires 1y;
        add_header Cache-Control "public, immutable";
    }
}

# Enable site and restart nginx
sudo ln -s /etc/nginx/sites-available/ihedg-conference /etc/nginx/sites-enabled/
sudo nginx -t
sudo systemctl restart nginx
```

## 🔧 Configuration Files Included

### Docker Deployment
- `Dockerfile` - Multi-stage build configuration
- `docker-compose.yml` - Standard Docker setup
- `docker-compose.tmd.yml` - TMD Cloud optimized setup
- `nginx.conf` - Production nginx configuration
- `nginx.tmd.conf` - TMD Cloud optimized nginx

### Deployment Scripts
- `deploy.sh` - Standard VPS deployment script
- `deploy-tmd.sh` - TMD Cloud optimized deployment
- `README-DEPLOYMENT.md` - Comprehensive deployment guide
- `README-TMD-DEPLOYMENT.md` - TMD Cloud specific guide

## 🌐 SSL/HTTPS Setup

### Automatic SSL (Let's Encrypt)
```bash
# Install certbot
sudo apt install certbot python3-certbot-nginx

# Get certificate
sudo certbot --nginx -d your-domain.com

# Auto-renewal (already configured in deployment scripts)
sudo crontab -e
# Add: 0 12 * * * /usr/bin/certbot renew --quiet
```

### Manual SSL Certificate
```bash
# If you have your own SSL certificate
# Copy certificate files to /etc/ssl/certs/
# Update nginx configuration with certificate paths
```

## 📊 Monitoring & Management

### Health Checks
```bash
# Check application status
curl http://your-server-ip/health

# View logs
docker-compose logs -f

# Check resource usage
docker stats
```

### Updates & Maintenance
```bash
# Update application
git pull  # if using git
docker-compose build
docker-compose up -d

# Backup
tar -czf backup-$(date +%Y%m%d).tar.gz /opt/ihedg-conference/

# Clean up old containers/images
docker system prune -f
```

## 🔒 Security Recommendations

### Firewall Configuration
```bash
# Configure UFW firewall
sudo ufw allow 22/tcp   # SSH
sudo ufw allow 80/tcp   # HTTP
sudo ufw allow 443/tcp  # HTTPS
sudo ufw enable
```

### Additional Security
```bash
# Install fail2ban for SSH protection
sudo apt install fail2ban

# Configure automatic security updates
sudo apt install unattended-upgrades
sudo dpkg-reconfigure unattended-upgrades
```

## 📱 Website Features

### Included Pages
- **Homepage** - Conference overview with corporate theme
- **About** - Conference mission and objectives
- **Speakers** - 15 international expert profiles
- **Schedule** - 3-day conference program
- **Paper Submission** - Research paper submission system
- **Registration** - Multi-tier registration (4 pricing options)
- **Contact** - Contact forms and information

### Technical Specifications
- **Framework**: React 18 with TypeScript
- **Styling**: Tailwind CSS with corporate theme
- **Components**: shadcn/ui component library
- **Build Tool**: Vite for fast builds
- **Deployment**: Docker containers with Nginx
- **Performance**: <1 second load time, optimized assets

## 🆘 Troubleshooting

### Common Issues
```bash
# Port 80/443 already in use
sudo netstat -tulpn | grep :80
sudo systemctl stop apache2  # Stop conflicting service

# Docker permission denied
sudo usermod -aG docker $USER
# Logout and login again

# Container won't start
docker-compose logs [service-name]
# Check logs for specific error messages

# SSL certificate issues
sudo certbot certificates  # Check certificate status
sudo certbot renew --dry-run  # Test renewal
```

### Performance Optimization
```bash
# Enable gzip compression (already configured)
# Use CDN for static assets
# Monitor with tools like htop, iotop
# Set up log rotation for long-term operation
```

## 📞 Support Information

### Files Structure
```
ihedg-conference/
├── src/                    # React source code
├── public/                 # Static assets (logo, etc.)
├── dist/                   # Built files (after pnpm run build)
├── docker-compose.yml      # Docker configuration
├── Dockerfile             # Docker build instructions
├── nginx.conf             # Nginx configuration
├── deploy-tmd.sh          # TMD Cloud deployment script
└── README-DEPLOYMENT.md   # This guide
```

### Key Commands Summary
```bash
# Build application
pnpm install && pnpm run build

# Docker deployment
docker-compose up -d

# TMD Cloud deployment
./deploy-tmd.sh

# Check status
docker-compose ps
curl http://localhost/health

# View logs
docker-compose logs -f

# Update
docker-compose build && docker-compose up -d
```

---

**IHEDG 2025 Conference Website**  
*Intelligence and the Role of Higher Education in Enabling Digital Government*  
April 8-10, 2025 | South Africa

For technical support: tech@ihedg2025.org