# Project Summary
The IHEDG 2025 Conference website serves as a digital hub for the "Artificial Intelligence and the Role of Higher Education in Enabling Digital Government" conference scheduled for April 8-10, 2025, at the Courtyard Hotel in Sandton, Johannesburg, South Africa. It connects academics, researchers, and policymakers by providing essential information such as speaker profiles, paper submission guidelines, registration details, and an interactive venue map to enhance attendee engagement.

# Project Module Description
The website comprises several key modules:
- **Homepage**: Overview of the conference, including dates and location.
- **About**: Information on the conference theme and objectives.
- **Speakers**: Profiles of expert speakers.
- **Schedule**: Detailed agenda for the conference.
- **Paper Submission**: Portal for submitting research papers.
- **Registration**: Forms for attendee registration.
- **Contact**: Inquiry form, venue details, and interactive map.

# Directory Tree
```
shadcn-ui/
├── Dockerfile                 # Docker container configuration
├── docker-compose.yml         # Docker orchestration setup
├── docker-compose-tmd.yml     # TMD Cloud optimized Docker configuration
├── nginx.conf                 # Nginx server configuration
├── nginx-tmd.conf             # Performance-tuned Nginx for TMD Cloud
├── deploy.sh                  # Deployment script for VPS
├── deploy-tmd.sh              # Automated TMD Cloud deployment script
├── README-DEPLOYMENT.md       # General deployment guide
├── README-TMD-DEPLOYMENT.md   # TMD Cloud specific deployment guide
├── index.html                 # Main HTML entry point
├── package.json               # Project dependencies and scripts
├── src/                       # Source files for the application
│   ├── App.css                # Global styles
│   ├── App.tsx                # Main application component
│   ├── components/            # UI components
│   ├── pages/                 # Page components
│   ├── index.css              # Global CSS styles
│   └── hooks/                 # Custom hooks
└── public/                    # Static assets
    └── logo.png               # Conference logo
```

# File Description Inventory
- **Dockerfile**: Configures the Docker image for the application.
- **docker-compose.yml**: Defines services and networking for deployment.
- **docker-compose-tmd.yml**: TMD Cloud optimized Docker Compose configuration.
- **nginx.conf**: Configuration file for serving the application using Nginx.
- **nginx-tmd.conf**: Nginx configuration optimized for TMD Cloud performance.
- **deploy.sh**: Script to automate the deployment process on a VPS.
- **deploy-tmd.sh**: Automated deployment script tailored for TMD Cloud.
- **README-DEPLOYMENT.md**: Instructions for general deployment of the conference website.
- **README-TMD-DEPLOYMENT.md**: Comprehensive TMD Cloud deployment guide.
- **index.html**: The main HTML file that serves the React application.
- **src/**: Contains the React application source code, including components and pages.

# Technology Stack
- **Frontend**: React 18, TypeScript, Tailwind CSS, Vite
- **Backend**: Nginx for serving the application
- **Containerization**: Docker for deploying the application
- **Deployment**: Docker Compose for managing services

# Usage
1. **Install Dependencies**:
   ```bash
   pnpm install
   ```
2. **Build the Application**:
   ```bash
   pnpm run build
   ```
3. **Run the Application**:
   Use Docker to build and start the application:
   ```bash
   chmod +x deploy-tmd.sh && ./deploy-tmd.sh
   ```
