import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Badge } from '@/components/ui/badge';
import { Clock, MapPin, Users } from 'lucide-react';

export default function Schedule() {
  const schedule = {
    "Day 1 - Tuesday, April 8, 2025": {
      theme: "Foundations of AI in Digital Government",
      sessions: [
        {
          time: "08:00 - 09:00",
          title: "Registration & Welcome Coffee",
          type: "Registration",
          speaker: "",
          description: "Welcome reception and networking"
        },
        {
          time: "09:00 - 09:30",
          title: "Opening Ceremony",
          type: "Keynote",
          speaker: "Conference Organizing Committee",
          description: "Welcome address and conference overview"
        },
        {
          time: "09:30 - 10:30",
          title: "AI Policy Frameworks for Government Innovation",
          type: "Keynote",
          speaker: "Dr. Sarah Chen",
          description: "Exploring policy frameworks that enable responsible AI adoption in government"
        },
        {
          time: "10:30 - 11:00",
          title: "Coffee Break",
          type: "Break",
          speaker: "",
          description: "Networking and refreshments"
        },
        {
          time: "11:00 - 12:00",
          title: "African Perspectives on Digital Governance",
          type: "Presentation",
          speaker: "Prof. Kwame Asante",
          description: "Digital transformation challenges and opportunities in African contexts"
        },
        {
          time: "12:00 - 13:00",
          title: "Panel: University-Government Partnerships",
          type: "Panel",
          speaker: "Dr. Maria Rodriguez, Prof. Raj Patel, Dr. Emma Thompson",
          description: "Building effective collaborations between academia and government"
        },
        {
          time: "13:00 - 14:00",
          title: "Lunch Break",
          type: "Break",
          speaker: "",
          description: "Networking lunch"
        },
        {
          time: "14:00 - 15:00",
          title: "Machine Learning Applications in Public Policy",
          type: "Presentation",
          speaker: "Prof. Jean-Luc Dubois",
          description: "Practical applications of ML in policy development and implementation"
        },
        {
          time: "15:00 - 16:00",
          title: "AI Ethics and Government Decision-Making",
          type: "Presentation",
          speaker: "Dr. Fatima Al-Zahra",
          description: "Ethical considerations in AI-powered government services"
        },
        {
          time: "16:00 - 16:30",
          title: "Afternoon Tea",
          type: "Break",
          speaker: "",
          description: "Networking and refreshments"
        },
        {
          time: "16:30 - 17:30",
          title: "Workshop: Digital Governance Frameworks",
          type: "Workshop",
          speaker: "Prof. Michael O'Brien",
          description: "Interactive session on designing effective digital governance structures"
        }
      ]
    },
    "Day 2 - Wednesday, April 9, 2025": {
      theme: "Implementation and Innovation",
      sessions: [
        {
          time: "09:00 - 10:00",
          title: "Smart Cities and Digital Infrastructure",
          type: "Keynote",
          speaker: "Dr. Liu Wei",
          description: "Building intelligent urban systems through government-academia collaboration"
        },
        {
          time: "10:00 - 11:00",
          title: "Digital Inclusion and Citizen Engagement",
          type: "Presentation",
          speaker: "Prof. Anna Kowalski",
          description: "Ensuring equitable access to digital government services"
        },
        {
          time: "11:00 - 11:30",
          title: "Coffee Break",
          type: "Break",
          speaker: "",
          description: "Networking and refreshments"
        },
        {
          time: "11:30 - 12:30",
          title: "Latin American Digital Transformation Case Studies",
          type: "Presentation",
          speaker: "Dr. Carlos Mendoza",
          description: "Lessons learned from digital government initiatives across Latin America"
        },
        {
          time: "12:30 - 13:30",
          title: "Panel: Sustainable Technology in Government",
          type: "Panel",
          speaker: "Prof. Ingrid Larsson, Dr. Ahmed Hassan, Prof. Yuki Tanaka",
          description: "Environmental and social sustainability in digital government projects"
        },
        {
          time: "13:30 - 14:30",
          title: "Lunch Break",
          type: "Break",
          speaker: "",
          description: "Networking lunch"
        },
        {
          time: "14:30 - 15:30",
          title: "Large-Scale Digital Implementation Strategies",
          type: "Presentation",
          speaker: "Dr. Priya Sharma",
          description: "Managing complex digital transformation projects at national scale"
        },
        {
          time: "15:30 - 16:30",
          title: "Paper Presentations Session 1",
          type: "Research",
          speaker: "Selected Paper Authors",
          description: "Presentation of accepted research papers"
        },
        {
          time: "16:30 - 17:00",
          title: "Afternoon Tea",
          type: "Break",
          speaker: "",
          description: "Networking and refreshments"
        },
        {
          time: "17:00 - 18:00",
          title: "Workshop: AI Governance Best Practices",
          type: "Workshop",
          speaker: "Multiple Speakers",
          description: "Collaborative workshop on developing AI governance guidelines"
        },
        {
          time: "19:00 - 21:00",
          title: "Conference Dinner",
          type: "Social",
          speaker: "",
          description: "Networking dinner with cultural program"
        }
      ]
    },
    "Day 3 - Thursday, April 10, 2025": {
      theme: "Future Directions and Collaboration",
      sessions: [
        {
          time: "09:00 - 10:00",
          title: "The Future of AI in Government: A Global Perspective",
          type: "Keynote",
          speaker: "Panel of All Speakers",
          description: "Collaborative discussion on emerging trends and future directions"
        },
        {
          time: "10:00 - 11:00",
          title: "Paper Presentations Session 2",
          type: "Research",
          speaker: "Selected Paper Authors",
          description: "Presentation of accepted research papers"
        },
        {
          time: "11:00 - 11:30",
          title: "Coffee Break",
          type: "Break",
          speaker: "",
          description: "Final networking opportunity"
        },
        {
          time: "11:30 - 12:30",
          title: "Building International Collaboration Networks",
          type: "Workshop",
          speaker: "All Speakers",
          description: "Interactive session on fostering global partnerships"
        },
        {
          time: "12:30 - 13:00",
          title: "Conference Conclusions and Next Steps",
          type: "Closing",
          speaker: "Conference Organizing Committee",
          description: "Summary of key insights and future collaboration opportunities"
        },
        {
          time: "13:00 - 14:00",
          title: "Closing Lunch",
          type: "Social",
          speaker: "",
          description: "Final networking and farewell"
        }
      ]
    }
  };

  const getTypeColor = (type: string) => {
    switch (type) {
      case 'Keynote': return 'bg-blue-600 text-white';
      case 'Presentation': return 'bg-green-600 text-white';
      case 'Panel': return 'bg-purple-600 text-white';
      case 'Workshop': return 'bg-orange-600 text-white';
      case 'Research': return 'bg-red-600 text-white';
      case 'Break': return 'bg-gray-400 text-white';
      case 'Social': return 'bg-pink-600 text-white';
      case 'Registration': return 'bg-indigo-600 text-white';
      case 'Closing': return 'bg-blue-800 text-white';
      default: return 'bg-gray-600 text-white';
    }
  };

  return (
    <div className="min-h-screen bg-gradient-to-br from-blue-50 to-indigo-100 py-12 px-4">
      <div className="max-w-6xl mx-auto">
        <div className="text-center mb-12">
          <h1 className="text-4xl font-bold text-blue-900 mb-6">Conference Schedule</h1>
          <p className="text-xl text-gray-700 max-w-3xl mx-auto">
            Three days of intensive sessions exploring the intersection of AI, higher education, and digital government.
          </p>
          
          <div className="flex flex-wrap justify-center gap-4 mt-8">
            <div className="flex items-center space-x-2 text-blue-800">
              <Clock className="w-5 h-5" />
              <span className="font-medium">April 8-10, 2025</span>
            </div>
            <div className="flex items-center space-x-2 text-blue-800">
              <MapPin className="w-5 h-5" />
              <span className="font-medium">South Africa</span>
            </div>
            <div className="flex items-center space-x-2 text-blue-800">
              <Users className="w-5 h-5" />
              <span className="font-medium">15 Expert Speakers</span>
            </div>
          </div>
        </div>

        {Object.entries(schedule).map(([day, dayData]) => (
          <div key={day} className="mb-12">
            <Card className="border-blue-200 mb-6">
              <CardHeader className="bg-blue-900 text-white">
                <CardTitle className="text-2xl">{day}</CardTitle>
                <p className="text-blue-100 text-lg">{dayData.theme}</p>
              </CardHeader>
            </Card>

            <div className="space-y-4">
              {dayData.sessions.map((session, index) => (
                <Card key={index} className="border-blue-200 hover:shadow-md transition-shadow">
                  <CardContent className="p-6">
                    <div className="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
                      <div className="flex-1">
                        <div className="flex items-center gap-3 mb-2">
                          <Badge className={`${getTypeColor(session.type)} px-3 py-1`}>
                            {session.type}
                          </Badge>
                          <span className="text-sm font-medium text-gray-600">{session.time}</span>
                        </div>
                        <h3 className="text-lg font-semibold text-blue-900 mb-2">{session.title}</h3>
                        {session.speaker && (
                          <p className="text-sm font-medium text-gray-700 mb-2">
                            Speaker(s): {session.speaker}
                          </p>
                        )}
                        <p className="text-gray-600">{session.description}</p>
                      </div>
                    </div>
                  </CardContent>
                </Card>
              ))}
            </div>
          </div>
        ))}

        <div className="text-center mt-12">
          <Card className="border-blue-200 bg-blue-50">
            <CardContent className="p-8">
              <h3 className="text-xl font-bold text-blue-900 mb-4">Important Notes</h3>
              <div className="text-left max-w-2xl mx-auto space-y-2 text-gray-700">
                <p>• All sessions will be conducted in English with simultaneous translation available</p>
                <p>• Coffee breaks and meals are included in the registration fee</p>
                <p>• Paper presentation slots are allocated based on submission acceptance</p>
                <p>• Workshop materials will be provided on-site</p>
                <p>• Certificate of attendance will be issued to all participants</p>
              </div>
            </CardContent>
          </Card>
        </div>
      </div>
    </div>
  );
}