import { Card, CardContent } from '@/components/ui/card';
import { Badge } from '@/components/ui/badge';
import { MapPin, Building } from 'lucide-react';

export default function Speakers() {
  const speakers = [
    {
      id: 1,
      name: "Dr. Sarah Chen",
      title: "Director of AI Policy Research",
      organization: "MIT Technology Policy Program",
      country: "USA",
      expertise: ["AI Ethics", "Digital Policy", "Government Innovation"],
      bio: "Leading expert in AI policy development with 15+ years experience in government technology transformation."
    },
    {
      id: 2,
      name: "Prof. Kwame Asante",
      title: "Head of Digital Government Studies",
      organization: "University of Cape Town",
      country: "South Africa",
      expertise: ["E-Government", "Digital Transformation", "African Digital Policy"],
      bio: "Pioneer in African digital governance research with extensive experience in government digitization projects."
    },
    {
      id: 3,
      name: "Dr. Maria Rodriguez",
      title: "Chief Digital Officer",
      organization: "Ministry of Digital Affairs, Spain",
      country: "Spain",
      expertise: ["Digital Services", "Public Sector Innovation", "Citizen Engagement"],
      bio: "Former academic turned government leader, driving Spain's digital transformation initiatives."
    },
    {
      id: 4,
      name: "Prof. Raj Patel",
      title: "Professor of Computer Science",
      organization: "Indian Institute of Technology",
      country: "India",
      expertise: ["Machine Learning", "Smart Cities", "Digital Infrastructure"],
      bio: "Renowned researcher in AI applications for urban governance and smart city development."
    },
    {
      id: 5,
      name: "Dr. Emma Thompson",
      title: "Senior Research Fellow",
      organization: "Oxford Internet Institute",
      country: "UK",
      expertise: ["Digital Rights", "Data Governance", "Privacy Policy"],
      bio: "Expert in digital rights and data protection with focus on government data management."
    },
    {
      id: 6,
      name: "Prof. Jean-Luc Dubois",
      title: "Director of Public Innovation Lab",
      organization: "Sorbonne University",
      country: "France",
      expertise: ["Innovation Management", "Digital Transformation", "Public-Private Partnerships"],
      bio: "Leading researcher in public sector innovation and digital transformation strategies."
    },
    {
      id: 7,
      name: "Dr. Fatima Al-Zahra",
      title: "AI Research Director",
      organization: "King Abdullah University",
      country: "Saudi Arabia",
      expertise: ["AI Applications", "Government Automation", "Digital Strategy"],
      bio: "Expert in AI implementation for government services and automated decision-making systems."
    },
    {
      id: 8,
      name: "Prof. Michael O'Brien",
      title: "Chair of Digital Governance",
      organization: "University of Melbourne",
      country: "Australia",
      expertise: ["Digital Governance", "Policy Analysis", "Technology Assessment"],
      bio: "Leading authority on digital governance frameworks and technology policy evaluation."
    },
    {
      id: 9,
      name: "Dr. Liu Wei",
      title: "Deputy Director",
      organization: "Chinese Academy of Social Sciences",
      country: "China",
      expertise: ["Digital Economy", "Government Data", "Smart Governance"],
      bio: "Expert in digital economy policy and government data utilization for public services."
    },
    {
      id: 10,
      name: "Prof. Anna Kowalski",
      title: "Head of Digital Society Research",
      organization: "Warsaw University of Technology",
      country: "Poland",
      expertise: ["Digital Society", "E-Participation", "Digital Inclusion"],
      bio: "Researcher focused on digital society development and citizen participation in digital governance."
    },
    {
      id: 11,
      name: "Dr. Carlos Mendoza",
      title: "Director of Innovation",
      organization: "Universidad Nacional de Colombia",
      country: "Colombia",
      expertise: ["Public Innovation", "Digital Transformation", "Latin American Policy"],
      bio: "Expert in Latin American digital transformation and public sector innovation initiatives."
    },
    {
      id: 12,
      name: "Prof. Ingrid Larsson",
      title: "Professor of Digital Government",
      organization: "Stockholm School of Economics",
      country: "Sweden",
      expertise: ["Digital Government", "Nordic Model", "Sustainable Technology"],
      bio: "Leading researcher in Nordic digital government models and sustainable technology adoption."
    },
    {
      id: 13,
      name: "Dr. Ahmed Hassan",
      title: "Senior Policy Advisor",
      organization: "African Development Bank",
      country: "Tunisia",
      expertise: ["Development Policy", "Digital Infrastructure", "Capacity Building"],
      bio: "Expert in digital infrastructure development and capacity building across African nations."
    },
    {
      id: 14,
      name: "Prof. Yuki Tanaka",
      title: "Director of AI Governance Institute",
      organization: "University of Tokyo",
      country: "Japan",
      expertise: ["AI Governance", "Technology Ethics", "Digital Society"],
      bio: "Pioneer in AI governance research with focus on ethical AI implementation in government."
    },
    {
      id: 15,
      name: "Dr. Priya Sharma",
      title: "Chief Technology Strategist",
      organization: "Digital India Initiative",
      country: "India",
      expertise: ["Digital Strategy", "Large-scale Implementation", "Government Technology"],
      bio: "Key architect of India's digital transformation with expertise in large-scale government technology projects."
    }
  ];

  return (
    <div className="min-h-screen bg-gradient-to-br from-blue-50 to-indigo-100 py-12 px-4">
      <div className="max-w-7xl mx-auto">
        <div className="text-center mb-12">
          <h1 className="text-4xl font-bold text-blue-900 mb-6">Conference Speakers</h1>
          <p className="text-xl text-gray-700 max-w-3xl mx-auto">
            Meet our distinguished panel of 15 expert speakers from around the world, bringing diverse perspectives on AI, digital governance, and higher education.
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
          {speakers.map((speaker) => (
            <Card key={speaker.id} className="border-blue-200 hover:shadow-lg transition-all duration-300 hover:-translate-y-1">
              <CardContent className="p-6">
                <div className="text-center mb-4">
                  <div className="w-20 h-20 bg-gradient-to-br from-blue-600 to-indigo-600 rounded-full flex items-center justify-center mx-auto mb-4">
                    <span className="text-2xl font-bold text-white">
                      {speaker.name.split(' ').map(n => n[0]).join('')}
                    </span>
                  </div>
                  <h3 className="text-xl font-bold text-blue-900 mb-1">{speaker.name}</h3>
                  <p className="text-sm font-medium text-gray-700 mb-2">{speaker.title}</p>
                  
                  <div className="flex items-center justify-center space-x-4 text-sm text-gray-600 mb-3">
                    <div className="flex items-center space-x-1">
                      <Building className="w-4 h-4" />
                      <span className="truncate max-w-32">{speaker.organization}</span>
                    </div>
                  </div>
                  
                  <div className="flex items-center justify-center space-x-1 text-sm text-gray-600 mb-4">
                    <MapPin className="w-4 h-4" />
                    <span>{speaker.country}</span>
                  </div>
                </div>

                <div className="mb-4">
                  <div className="flex flex-wrap gap-2 justify-center">
                    {speaker.expertise.map((skill, index) => (
                      <Badge key={index} variant="secondary" className="text-xs bg-blue-100 text-blue-800">
                        {skill}
                      </Badge>
                    ))}
                  </div>
                </div>

                <p className="text-sm text-gray-600 text-center leading-relaxed">
                  {speaker.bio}
                </p>
              </CardContent>
            </Card>
          ))}
        </div>

        <div className="text-center mt-12">
          <p className="text-lg text-gray-700">
            More speaker announcements coming soon! Stay tuned for updates.
          </p>
        </div>
      </div>
    </div>
  );
}