import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Target, Lightbulb, Globe, GraduationCap } from 'lucide-react';

export default function About() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-blue-50 to-indigo-100 py-12 px-4">
      <div className="max-w-6xl mx-auto">
        <div className="text-center mb-12">
          <h1 className="text-4xl font-bold text-blue-900 mb-6">About the Conference</h1>
          <p className="text-xl text-gray-700 max-w-4xl mx-auto">
            Exploring the transformative role of artificial intelligence and higher education in building effective digital government systems.
          </p>
        </div>

        {/* Conference Theme */}
        <section className="mb-16">
          <Card className="border-blue-200">
            <CardHeader>
              <CardTitle className="text-2xl text-blue-900 text-center">Conference Theme</CardTitle>
            </CardHeader>
            <CardContent className="text-center">
              <p className="text-lg text-gray-700 leading-relaxed">
                In an era of rapid digital transformation, governments worldwide are leveraging artificial intelligence 
                and partnering with higher education institutions to create more efficient, transparent, and citizen-centric 
                public services. This conference brings together leading minds to explore how intelligent systems and 
                academic expertise can drive the evolution of digital governance.
              </p>
            </CardContent>
          </Card>
        </section>

        {/* Key Objectives */}
        <section className="mb-16">
          <h2 className="text-3xl font-bold text-center text-blue-900 mb-8">Key Objectives</h2>
          <div className="grid md:grid-cols-2 gap-8">
            <Card className="border-blue-200 hover:shadow-lg transition-shadow">
              <CardContent className="p-6">
                <div className="flex items-start space-x-4">
                  <div className="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center flex-shrink-0">
                    <Target className="w-6 h-6 text-blue-900" />
                  </div>
                  <div>
                    <h3 className="text-xl font-semibold text-blue-900 mb-2">Strategic Insights</h3>
                    <p className="text-gray-600">
                      Examine how AI technologies can enhance government decision-making processes and policy development.
                    </p>
                  </div>
                </div>
              </CardContent>
            </Card>

            <Card className="border-blue-200 hover:shadow-lg transition-shadow">
              <CardContent className="p-6">
                <div className="flex items-start space-x-4">
                  <div className="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center flex-shrink-0">
                    <Lightbulb className="w-6 h-6 text-blue-900" />
                  </div>
                  <div>
                    <h3 className="text-xl font-semibold text-blue-900 mb-2">Innovation Showcase</h3>
                    <p className="text-gray-600">
                      Present cutting-edge research and practical applications of AI in public sector transformation.
                    </p>
                  </div>
                </div>
              </CardContent>
            </Card>

            <Card className="border-blue-200 hover:shadow-lg transition-shadow">
              <CardContent className="p-6">
                <div className="flex items-start space-x-4">
                  <div className="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center flex-shrink-0">
                    <Globe className="w-6 h-6 text-blue-900" />
                  </div>
                  <div>
                    <h3 className="text-xl font-semibold text-blue-900 mb-2">Global Perspectives</h3>
                    <p className="text-gray-600">
                      Share international best practices and lessons learned from digital government initiatives.
                    </p>
                  </div>
                </div>
              </CardContent>
            </Card>

            <Card className="border-blue-200 hover:shadow-lg transition-shadow">
              <CardContent className="p-6">
                <div className="flex items-start space-x-4">
                  <div className="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center flex-shrink-0">
                    <GraduationCap className="w-6 h-6 text-blue-900" />
                  </div>
                  <div>
                    <h3 className="text-xl font-semibold text-blue-900 mb-2">Academic Collaboration</h3>
                    <p className="text-gray-600">
                      Foster partnerships between universities and government agencies for sustainable digital transformation.
                    </p>
                  </div>
                </div>
              </CardContent>
            </Card>
          </div>
        </section>

        {/* Topics */}
        <section>
          <h2 className="text-3xl font-bold text-center text-blue-900 mb-8">Conference Topics</h2>
          <Card className="border-blue-200">
            <CardContent className="p-8">
              <div className="grid md:grid-cols-2 gap-6">
                <div>
                  <h3 className="text-xl font-semibold text-blue-900 mb-4">AI & Digital Governance</h3>
                  <ul className="space-y-2 text-gray-700">
                    <li>• Machine Learning in Public Policy</li>
                    <li>• Predictive Analytics for Government</li>
                    <li>• AI Ethics in Public Sector</li>
                    <li>• Automated Decision Systems</li>
                  </ul>
                </div>
                <div>
                  <h3 className="text-xl font-semibold text-blue-900 mb-4">Higher Education Role</h3>
                  <ul className="space-y-2 text-gray-700">
                    <li>• University-Government Partnerships</li>
                    <li>• Research Translation to Policy</li>
                    <li>• Capacity Building Programs</li>
                    <li>• Digital Skills Development</li>
                  </ul>
                </div>
                <div>
                  <h3 className="text-xl font-semibold text-blue-900 mb-4">Digital Transformation</h3>
                  <ul className="space-y-2 text-gray-700">
                    <li>• E-Government Services</li>
                    <li>• Digital Identity Systems</li>
                    <li>• Blockchain in Government</li>
                    <li>• Cybersecurity Frameworks</li>
                  </ul>
                </div>
                <div>
                  <h3 className="text-xl font-semibold text-blue-900 mb-4">Future Perspectives</h3>
                  <ul className="space-y-2 text-gray-700">
                    <li>• Smart Cities Development</li>
                    <li>• Citizen Engagement Platforms</li>
                    <li>• Data-Driven Governance</li>
                    <li>• Sustainable Digital Solutions</li>
                  </ul>
                </div>
              </div>
            </CardContent>
          </Card>
        </section>
      </div>
    </div>
  );
}