import { Button } from '@/components/ui/button';
import { Card, CardContent } from '@/components/ui/card';
import { Calendar, MapPin, Users, FileText } from 'lucide-react';
import { Link } from 'react-router-dom';

export default function Index() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-blue-50 to-indigo-100">
      {/* Hero Section */}
      <section className="relative py-20 px-4 text-center">
        <div className="max-w-6xl mx-auto">
          <div className="mb-8">
            <h1 className="text-4xl md:text-6xl font-bold text-blue-900 mb-6 leading-tight">
              Intelligence and the Role of Higher Education in Enabling Digital Government
            </h1>
            <p className="text-xl md:text-2xl text-gray-700 mb-8 max-w-4xl mx-auto">
              Join leading academics, researchers, and policymakers in exploring the intersection of artificial intelligence, higher education, and digital governance.
            </p>
          </div>
          
          <div className="grid md:grid-cols-3 gap-6 mb-12 max-w-4xl mx-auto">
            <div className="flex items-center justify-center space-x-2 text-blue-800">
              <Calendar className="w-6 h-6" />
              <span className="font-semibold">April 8-10, 2025</span>
            </div>
            <div className="flex items-center justify-center space-x-2 text-blue-800">
              <MapPin className="w-6 h-6" />
              <span className="font-semibold">South Africa</span>
            </div>
            <div className="flex items-center justify-center space-x-2 text-blue-800">
              <Users className="w-6 h-6" />
              <span className="font-semibold">15 Expert Speakers</span>
            </div>
          </div>

          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button asChild size="lg" className="bg-blue-900 hover:bg-blue-800">
              <Link to="/register">Register Now</Link>
            </Button>
            <Button asChild variant="outline" size="lg" className="border-blue-900 text-blue-900 hover:bg-blue-50">
              <Link to="/submit-paper">Submit Paper</Link>
            </Button>
          </div>
        </div>
      </section>

      {/* Key Features */}
      <section className="py-16 px-4 bg-white">
        <div className="max-w-6xl mx-auto">
          <h2 className="text-3xl font-bold text-center text-blue-900 mb-12">Conference Highlights</h2>
          <div className="grid md:grid-cols-3 gap-8">
            <Card className="border-blue-200 hover:shadow-lg transition-shadow">
              <CardContent className="p-6 text-center">
                <div className="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Users className="w-8 h-8 text-blue-900" />
                </div>
                <h3 className="text-xl font-semibold text-blue-900 mb-2">Expert Speakers</h3>
                <p className="text-gray-600">15 renowned experts from academia, government, and industry sharing cutting-edge insights.</p>
              </CardContent>
            </Card>

            <Card className="border-blue-200 hover:shadow-lg transition-shadow">
              <CardContent className="p-6 text-center">
                <div className="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                  <FileText className="w-8 h-8 text-blue-900" />
                </div>
                <h3 className="text-xl font-semibold text-blue-900 mb-2">Research Papers</h3>
                <p className="text-gray-600">Submit your research and contribute to the advancement of digital governance knowledge.</p>
              </CardContent>
            </Card>

            <Card className="border-blue-200 hover:shadow-lg transition-shadow">
              <CardContent className="p-6 text-center">
                <div className="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Calendar className="w-8 h-8 text-blue-900" />
                </div>
                <h3 className="text-xl font-semibold text-blue-900 mb-2">3-Day Program</h3>
                <p className="text-gray-600">Comprehensive sessions covering AI, digital transformation, and educational innovation.</p>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Call to Action */}
      <section className="py-16 px-4 bg-blue-900 text-white">
        <div className="max-w-4xl mx-auto text-center">
          <h2 className="text-3xl font-bold mb-6">Be Part of the Digital Future</h2>
          <p className="text-xl mb-8 opacity-90">
            Join us in shaping the future of digital government through intelligent higher education initiatives.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button asChild size="lg" variant="secondary">
              <Link to="/about">Learn More</Link>
            </Button>
            <Button asChild size="lg" variant="outline" className="border-white text-white hover:bg-white hover:text-blue-900">
              <Link to="/speakers">View Speakers</Link>
            </Button>
          </div>
        </div>
      </section>
    </div>
  );
}