import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { Textarea } from '@/components/ui/textarea';
import { MapPin, Phone, Mail, Clock, Building, Users, Navigation } from 'lucide-react';

export default function Contact() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-slate-900 via-blue-900 to-gray-900 relative overflow-hidden">
      {/* Subtle background elements */}
      <div className="absolute inset-0 overflow-hidden">
        <div className="absolute top-20 left-10 w-32 h-32 bg-gradient-to-br from-blue-600 to-slate-700 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-pulse"></div>
        <div className="absolute bottom-20 right-10 w-40 h-40 bg-gradient-to-br from-slate-600 to-blue-800 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-pulse animation-delay-2000"></div>
        <div className="absolute top-1/2 left-1/3 w-24 h-24 bg-gradient-to-br from-gray-700 to-blue-700 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-pulse animation-delay-4000"></div>
      </div>

      <div className="relative py-12 px-4">
        <div className="max-w-6xl mx-auto">
          <div className="text-center mb-12">
            <div className="inline-flex items-center px-6 py-3 bg-gradient-to-r from-blue-600 to-slate-700 rounded-full text-white text-sm font-medium mb-8 shadow-lg">
              <Building className="w-4 h-4 mr-2" />
              Get In Touch
            </div>
            <h1 className="text-4xl md:text-6xl font-bold text-white mb-6">
              Contact Us
            </h1>
            <p className="text-xl text-gray-300 max-w-4xl mx-auto leading-relaxed">
              Have questions about the conference? We're here to help. Reach out to us for any inquiries about registration, 
              paper submissions, or general information.
            </p>
          </div>

          <div className="grid lg:grid-cols-2 gap-12">
            {/* Contact Information */}
            <div className="space-y-8">
              <Card className="bg-white/5 backdrop-blur-md border border-white/10 hover:bg-white/8 transition-all duration-300 shadow-xl">
                <CardHeader>
                  <CardTitle className="text-2xl text-white flex items-center gap-3">
                    <MapPin className="w-6 h-6 text-blue-400" />
                    Venue Information
                  </CardTitle>
                </CardHeader>
                <CardContent className="space-y-4">
                  <div className="bg-white/5 rounded-lg p-4 border border-white/10">
                    <h3 className="text-lg font-semibold text-white mb-2">Courtyard Hotel, Sandton</h3>
                    <p className="text-gray-300 mb-2">
                      Corner Rivonia Road & Maude Street<br />
                      Sandton, Johannesburg<br />
                      South Africa, 2196
                    </p>
                    <p className="text-sm text-gray-400">
                      Located in the heart of Sandton's business district, offering world-class conference facilities 
                      and easy access to OR Tambo International Airport.
                    </p>
                  </div>
                </CardContent>
              </Card>

              <Card className="bg-white/5 backdrop-blur-md border border-white/10 hover:bg-white/8 transition-all duration-300 shadow-xl">
                <CardHeader>
                  <CardTitle className="text-2xl text-white flex items-center gap-3">
                    <Phone className="w-6 h-6 text-slate-400" />
                    Contact Details
                  </CardTitle>
                </CardHeader>
                <CardContent className="space-y-4">
                  <div className="space-y-3">
                    <div className="flex items-center space-x-3">
                      <Mail className="w-5 h-5 text-blue-400" />
                      <div>
                        <p className="text-white font-medium">Email</p>
                        <p className="text-gray-300">info@aihedg2025.org</p>
                      </div>
                    </div>
                    <div className="flex items-center space-x-3">
                      <Phone className="w-5 h-5 text-slate-400" />
                      <div>
                        <p className="text-white font-medium">Phone</p>
                        <p className="text-gray-300">+27 11 074 5214</p>
                      </div>
                    </div>
                    <div className="flex items-center space-x-3">
                      <Clock className="w-5 h-5 text-gray-400" />
                      <div>
                        <p className="text-white font-medium">Office Hours</p>
                        <p className="text-gray-300">Monday - Friday: 9:00 AM - 5:00 PM (SAST)</p>
                      </div>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="bg-white/5 backdrop-blur-md border border-white/10 hover:bg-white/8 transition-all duration-300 shadow-xl">
                <CardHeader>
                  <CardTitle className="text-2xl text-white">Conference Dates</CardTitle>
                </CardHeader>
                <CardContent>
                  <div className="bg-gradient-to-r from-blue-600/20 to-slate-700/20 rounded-lg p-4 border border-white/10">
                    <p className="text-lg font-semibold text-white mb-2">April 8-10, 2025</p>
                    <p className="text-gray-300">
                      Three days of intensive sessions, workshops, and networking opportunities focused on 
                      artificial intelligence and digital government transformation.
                    </p>
                  </div>
                </CardContent>
              </Card>
            </div>

            {/* Contact Form */}
            <div>
              <Card className="bg-white/5 backdrop-blur-md border border-white/10 shadow-xl">
                <CardHeader>
                  <CardTitle className="text-2xl text-white">Send us a Message</CardTitle>
                </CardHeader>
                <CardContent className="space-y-6">
                  <div className="grid md:grid-cols-2 gap-4">
                    <div>
                      <label className="block text-sm font-medium text-gray-300 mb-2">First Name</label>
                      <Input 
                        placeholder="Enter your first name" 
                        className="bg-white/10 border-white/20 text-white placeholder-gray-400 focus:border-blue-400"
                      />
                    </div>
                    <div>
                      <label className="block text-sm font-medium text-gray-300 mb-2">Last Name</label>
                      <Input 
                        placeholder="Enter your last name" 
                        className="bg-white/10 border-white/20 text-white placeholder-gray-400 focus:border-blue-400"
                      />
                    </div>
                  </div>
                  
                  <div>
                    <label className="block text-sm font-medium text-gray-300 mb-2">Email Address</label>
                    <Input 
                      type="email" 
                      placeholder="Enter your email address" 
                      className="bg-white/10 border-white/20 text-white placeholder-gray-400 focus:border-blue-400"
                    />
                  </div>
                  
                  <div>
                    <label className="block text-sm font-medium text-gray-300 mb-2">Organization</label>
                    <Input 
                      placeholder="Enter your organization name" 
                      className="bg-white/10 border-white/20 text-white placeholder-gray-400 focus:border-blue-400"
                    />
                  </div>
                  
                  <div>
                    <label className="block text-sm font-medium text-gray-300 mb-2">Subject</label>
                    <Input 
                      placeholder="Enter message subject" 
                      className="bg-white/10 border-white/20 text-white placeholder-gray-400 focus:border-blue-400"
                    />
                  </div>
                  
                  <div>
                    <label className="block text-sm font-medium text-gray-300 mb-2">Message</label>
                    <Textarea 
                      placeholder="Enter your message here..." 
                      rows={6}
                      className="bg-white/10 border-white/20 text-white placeholder-gray-400 focus:border-blue-400 resize-none"
                    />
                  </div>
                  
                  <Button className="w-full bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white font-semibold py-3 rounded-lg shadow-lg transform hover:scale-105 transition-all duration-300">
                    Send Message
                  </Button>
                  
                  <p className="text-sm text-gray-400 text-center">
                    We'll respond to your inquiry within 24 hours during business days.
                  </p>
                </CardContent>
              </Card>
            </div>
          </div>

          {/* Interactive Map Section */}
          <div className="mt-16">
            <Card className="bg-white/5 backdrop-blur-md border border-white/10 shadow-xl">
              <CardHeader>
                <CardTitle className="text-3xl text-white text-center flex items-center justify-center gap-3">
                  <Navigation className="w-8 h-8 text-blue-400" />
                  Venue Location
                </CardTitle>
              </CardHeader>
              <CardContent className="p-6">
                <div className="bg-white/10 rounded-lg p-4 border border-white/10 mb-6">
                  <div className="w-full h-96 bg-gray-800 rounded-lg overflow-hidden shadow-lg">
                    <iframe
                      src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3583.5234567890123!2d28.0541234567890!3d-26.1076543210987!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x1e950c68f0b6e025%3A0x8e5f8b5a5c5d5e5f!2sCourtyard%20by%20Marriott%20Sandton!5e0!3m2!1sen!2sza!4v1234567890123!5m2!1sen!2sza"
                      width="100%"
                      height="100%"
                      style={{ border: 0 }}
                      allowFullScreen
                      loading="lazy"
                      referrerPolicy="no-referrer-when-downgrade"
                      className="rounded-lg"
                    ></iframe>
                  </div>
                </div>
                
                <div className="grid md:grid-cols-2 gap-6">
                  <div className="bg-white/5 rounded-lg p-4 border border-white/10">
                    <h4 className="text-lg font-semibold text-white mb-3 flex items-center gap-2">
                      <MapPin className="w-5 h-5 text-blue-400" />
                      Directions
                    </h4>
                    <ul className="space-y-2 text-gray-300 text-sm">
                      <li>• <strong>From OR Tambo Airport:</strong> 25 minutes via R21 and M1</li>
                      <li>• <strong>From Johannesburg CBD:</strong> 15 minutes via M1 North</li>
                      <li>• <strong>From Pretoria:</strong> 45 minutes via N1 and M1</li>
                      <li>• <strong>Gautrain:</strong> 5-minute walk from Sandton Station</li>
                    </ul>
                  </div>
                  
                  <div className="bg-white/5 rounded-lg p-4 border border-white/10">
                    <h4 className="text-lg font-semibold text-white mb-3 flex items-center gap-2">
                      <Building className="w-5 h-5 text-slate-400" />
                      Nearby Landmarks
                    </h4>
                    <ul className="space-y-2 text-gray-300 text-sm">
                      <li>• <strong>Sandton City Mall:</strong> 2-minute walk</li>
                      <li>• <strong>Nelson Mandela Square:</strong> 3-minute walk</li>
                      <li>• <strong>Sandton Convention Centre:</strong> 5-minute walk</li>
                      <li>• <strong>JSE (Stock Exchange):</strong> 10-minute walk</li>
                    </ul>
                  </div>
                </div>
                
                <div className="mt-6 text-center">
                  <Button 
                    className="bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white font-semibold py-3 px-8 rounded-lg shadow-lg transform hover:scale-105 transition-all duration-300"
                    onClick={() => window.open('https://maps.google.com/?q=Courtyard+by+Marriott+Sandton,+Corner+Rivonia+Road+%26+Maude+Street,+Sandton,+Johannesburg', '_blank')}
                  >
                    <Navigation className="w-5 h-5 mr-2" />
                    Get Directions
                  </Button>
                </div>
              </CardContent>
            </Card>
          </div>

          {/* Additional Information */}
          <div className="mt-16">
            <Card className="bg-gradient-to-r from-slate-800/20 to-blue-800/20 backdrop-blur-md border border-white/10 shadow-xl">
              <CardContent className="p-8">
                <h2 className="text-3xl font-bold text-white mb-6 text-center">Getting to Courtyard Hotel, Sandton</h2>
                <div className="grid md:grid-cols-3 gap-8">
                  <div className="text-center">
                    <div className="w-16 h-16 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center mx-auto mb-4 shadow-lg">
                      <MapPin className="w-8 h-8 text-white" />
                    </div>
                    <h3 className="text-lg font-semibold text-white mb-2">From OR Tambo Airport</h3>
                    <p className="text-gray-300 text-sm">
                      25-minute drive via the R21 and M1 highways. Airport shuttles and ride-sharing services available.
                    </p>
                  </div>
                  
                  <div className="text-center">
                    <div className="w-16 h-16 bg-gradient-to-br from-slate-500 to-slate-600 rounded-lg flex items-center justify-center mx-auto mb-4 shadow-lg">
                      <Building className="w-8 h-8 text-white" />
                    </div>
                    <h3 className="text-lg font-semibold text-white mb-2">Sandton City</h3>
                    <p className="text-gray-300 text-sm">
                      Walking distance to Sandton City Mall and Gautrain station. Easy access to shopping and dining.
                    </p>
                  </div>
                  
                  <div className="text-center">
                    <div className="w-16 h-16 bg-gradient-to-br from-gray-500 to-gray-600 rounded-lg flex items-center justify-center mx-auto mb-4 shadow-lg">
                      <Clock className="w-8 h-8 text-white" />
                    </div>
                    <h3 className="text-lg font-semibold text-white mb-2">Public Transport</h3>
                    <p className="text-gray-300 text-sm">
                      Gautrain connects to Sandton station. Bus routes and taxi services readily available.
                    </p>
                  </div>
                </div>
              </CardContent>
            </Card>
          </div>
        </div>
      </div>
    </div>
  );
}