import { Button } from '@/components/ui/button';
import { Card, CardContent } from '@/components/ui/card';
import { Calendar, MapPin, Users, FileText, Award, Target, Building } from 'lucide-react';
import { Link } from 'react-router-dom';

export default function Index() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-slate-900 via-blue-900 to-gray-900 relative overflow-hidden">
      {/* Subtle background elements */}
      <div className="absolute inset-0 overflow-hidden">
        <div className="absolute -top-40 -right-40 w-80 h-80 bg-gradient-to-br from-blue-600 to-slate-700 rounded-full mix-blend-multiply filter blur-xl opacity-30 animate-pulse"></div>
        <div className="absolute -bottom-40 -left-40 w-80 h-80 bg-gradient-to-br from-slate-600 to-blue-800 rounded-full mix-blend-multiply filter blur-xl opacity-30 animate-pulse animation-delay-2000"></div>
        <div className="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-80 h-80 bg-gradient-to-br from-gray-700 to-blue-700 rounded-full mix-blend-multiply filter blur-xl opacity-30 animate-pulse animation-delay-4000"></div>
      </div>

      {/* Hero Section */}
      <section className="relative py-20 px-4 text-center">
        <div className="max-w-6xl mx-auto">
          <div className="mb-8">
            <div className="inline-flex items-center px-6 py-3 bg-gradient-to-r from-blue-600 to-slate-700 rounded-full text-white text-sm font-medium mb-8 shadow-lg">
              <Award className="w-4 h-4 mr-2" />
              April 8-10, 2025 • Cape Town, South Africa
            </div>
            
            <h1 className="text-3xl md:text-6xl font-bold text-white mb-6 leading-tight">
              Artificial Intelligence and the Role of Higher Education
              <span className="block text-2xl md:text-4xl mt-2 text-blue-400">
                in Enabling Digital Government
              </span>
            </h1>
            
            <p className="text-xl md:text-2xl text-gray-300 mb-8 max-w-4xl mx-auto leading-relaxed">
              Join leading academics, researchers, and policymakers in exploring how 
              <span className="text-blue-400 font-semibold"> artificial intelligence</span> and 
              <span className="text-slate-400 font-semibold"> higher education partnerships</span> can transform 
              <span className="text-gray-400 font-semibold"> digital governance</span>
            </p>
          </div>
          
          <div className="grid md:grid-cols-3 gap-6 mb-12 max-w-4xl mx-auto">
            <div className="flex items-center justify-center space-x-3 bg-white/5 backdrop-blur-md rounded-xl p-4 border border-white/10">
              <Calendar className="w-6 h-6 text-blue-400" />
              <span className="font-semibold text-white">3 Days</span>
            </div>
            <div className="flex items-center justify-center space-x-3 bg-white/5 backdrop-blur-md rounded-xl p-4 border border-white/10">
              <MapPin className="w-6 h-6 text-slate-400" />
              <span className="font-semibold text-white">South Africa</span>
            </div>
            <div className="flex items-center justify-center space-x-3 bg-white/5 backdrop-blur-md rounded-xl p-4 border border-white/10">
              <Users className="w-6 h-6 text-gray-400" />
              <span className="font-semibold text-white">15 Expert Speakers</span>
            </div>
          </div>

          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button asChild size="lg" className="bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white font-semibold py-4 px-8 rounded-lg shadow-lg transform hover:scale-105 transition-all duration-300">
              <Link to="/register">Register Now</Link>
            </Button>
            <Button asChild variant="outline" size="lg" className="border-2 border-slate-400 text-slate-300 hover:bg-slate-700 hover:text-white font-semibold py-4 px-8 rounded-lg backdrop-blur-sm bg-white/5 shadow-lg transform hover:scale-105 transition-all duration-300">
              <Link to="/submit-paper">Submit Paper</Link>
            </Button>
          </div>
        </div>
      </section>

      {/* Key Features */}
      <section className="relative py-16 px-4">
        <div className="max-w-6xl mx-auto">
          <h2 className="text-4xl font-bold text-center text-white mb-12">
            Conference Highlights
          </h2>
          <div className="grid md:grid-cols-3 gap-8">
            <Card className="bg-white/5 backdrop-blur-md border border-white/10 hover:bg-white/10 transition-all duration-300 transform hover:scale-105 hover:-translate-y-2">
              <CardContent className="p-6 text-center">
                <div className="w-16 h-16 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center mx-auto mb-4 shadow-lg">
                  <Users className="w-8 h-8 text-white" />
                </div>
                <h3 className="text-xl font-semibold text-white mb-2">Expert Speakers</h3>
                <p className="text-gray-300">15 renowned experts from academia, government, and industry sharing cutting-edge insights and best practices.</p>
              </CardContent>
            </Card>

            <Card className="bg-white/5 backdrop-blur-md border border-white/10 hover:bg-white/10 transition-all duration-300 transform hover:scale-105 hover:-translate-y-2">
              <CardContent className="p-6 text-center">
                <div className="w-16 h-16 bg-gradient-to-br from-slate-500 to-slate-600 rounded-lg flex items-center justify-center mx-auto mb-4 shadow-lg">
                  <FileText className="w-8 h-8 text-white" />
                </div>
                <h3 className="text-xl font-semibold text-white mb-2">Research Papers</h3>
                <p className="text-gray-300">Submit your research and contribute to the advancement of digital governance knowledge and innovation.</p>
              </CardContent>
            </Card>

            <Card className="bg-white/5 backdrop-blur-md border border-white/10 hover:bg-white/10 transition-all duration-300 transform hover:scale-105 hover:-translate-y-2">
              <CardContent className="p-6 text-center">
                <div className="w-16 h-16 bg-gradient-to-br from-gray-500 to-gray-600 rounded-lg flex items-center justify-center mx-auto mb-4 shadow-lg">
                  <Building className="w-8 h-8 text-white" />
                </div>
                <h3 className="text-xl font-semibold text-white mb-2">Professional Program</h3>
                <p className="text-gray-300">Comprehensive sessions covering AI applications, digital transformation, and educational innovation.</p>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Call to Action */}
      <section className="relative py-16 px-4">
        <div className="max-w-4xl mx-auto text-center">
          <div className="bg-gradient-to-r from-blue-900/40 to-slate-800/40 backdrop-blur-md rounded-2xl p-12 border border-white/10 shadow-2xl">
            <h2 className="text-4xl font-bold mb-6 text-white">
              Shape the Future of Digital Government
            </h2>
            <p className="text-xl mb-8 text-gray-300">
              Join us in exploring how artificial intelligence and higher education partnerships 
              can transform public sector services and citizen engagement.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Button asChild size="lg" className="bg-gradient-to-r from-slate-600 to-slate-700 hover:from-slate-700 hover:to-slate-800 text-white font-semibold py-4 px-8 rounded-lg shadow-lg transform hover:scale-105 transition-all duration-300">
                <Link to="/about">Learn More</Link>
              </Button>
              <Button asChild size="lg" className="bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white font-semibold py-4 px-8 rounded-lg shadow-lg transform hover:scale-105 transition-all duration-300">
                <Link to="/speakers">View Speakers</Link>
              </Button>
            </div>
          </div>
        </div>
      </section>
    </div>
  );
}