import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Target, Lightbulb, Globe, GraduationCap, Building, Users, Award, TrendingUp } from 'lucide-react';

export default function About() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-slate-900 via-blue-900 to-gray-900 relative overflow-hidden">
      {/* Subtle corporate background */}
      <div className="absolute inset-0 overflow-hidden">
        <div className="absolute top-20 left-10 w-32 h-32 bg-gradient-to-br from-blue-600/20 to-slate-600/20 rounded-full mix-blend-multiply filter blur-xl opacity-40 animate-pulse"></div>
        <div className="absolute bottom-20 right-10 w-40 h-40 bg-gradient-to-br from-gray-600/20 to-blue-600/20 rounded-full mix-blend-multiply filter blur-xl opacity-40 animate-pulse animation-delay-2000"></div>
        <div className="absolute top-1/2 left-1/3 w-24 h-24 bg-gradient-to-br from-slate-600/20 to-gray-600/20 rounded-full mix-blend-multiply filter blur-xl opacity-40 animate-pulse animation-delay-4000"></div>
      </div>

      <div className="relative py-12 px-4">
        <div className="max-w-6xl mx-auto">
          <div className="text-center mb-12">
            <div className="inline-flex items-center px-6 py-3 bg-gradient-to-r from-blue-600 to-slate-700 rounded-full text-white text-sm font-medium mb-6 shadow-lg">
              <Building className="w-4 h-4 mr-2" />
              Professional Conference
            </div>
            <h1 className="text-4xl md:text-6xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-blue-400 via-slate-300 to-gray-300 mb-6">
              About the Conference
            </h1>
            <p className="text-xl text-gray-300 max-w-4xl mx-auto leading-relaxed">
              Exploring the transformative role of <span className="text-blue-400 font-semibold">artificial intelligence</span> and 
              <span className="text-slate-300 font-semibold"> higher education</span> in building effective 
              <span className="text-gray-300 font-semibold"> digital government systems</span>
            </p>
          </div>

          {/* Conference Theme */}
          <section className="mb-16">
            <Card className="bg-white/10 backdrop-blur-md border border-slate-600/30 hover:bg-white/15 transition-all duration-300">
              <CardHeader className="text-center">
                <CardTitle className="text-3xl text-transparent bg-clip-text bg-gradient-to-r from-slate-300 to-blue-400 flex items-center justify-center gap-3">
                  <Award className="w-8 h-8 text-blue-400" />
                  Conference Mission
                  <TrendingUp className="w-8 h-8 text-slate-400" />
                </CardTitle>
              </CardHeader>
              <CardContent className="text-center">
                <p className="text-lg text-gray-300 leading-relaxed">
                  In an era of rapid <span className="text-blue-400 font-semibold">digital transformation</span>, governments worldwide are leveraging 
                  artificial intelligence and partnering with <span className="text-slate-300 font-semibold">higher education institutions</span> to create 
                  more efficient, transparent, and citizen-centric public services. This conference brings together leading minds to explore how 
                  intelligent systems and academic expertise can drive the evolution of <span className="text-gray-300 font-semibold">digital governance</span>.
                </p>
              </CardContent>
            </Card>
          </section>

          {/* Key Objectives */}
          <section className="mb-16">
            <h2 className="text-4xl font-bold text-center text-transparent bg-clip-text bg-gradient-to-r from-slate-300 to-blue-400 mb-8">
              Key Objectives
            </h2>
            <div className="grid md:grid-cols-2 gap-8">
              <Card className="bg-gradient-to-br from-blue-600/20 to-slate-700/20 backdrop-blur-md border border-slate-600/30 hover:scale-105 transition-all duration-300 group">
                <CardContent className="p-6">
                  <div className="flex items-start space-x-4">
                    <div className="w-12 h-12 bg-gradient-to-br from-blue-600 to-slate-700 rounded-lg flex items-center justify-center flex-shrink-0 group-hover:scale-110 transition-transform duration-300">
                      <Target className="w-6 h-6 text-white" />
                    </div>
                    <div>
                      <h3 className="text-xl font-semibold text-white mb-2">Strategic Insights</h3>
                      <p className="text-gray-300">
                        Examine how AI technologies can enhance government decision-making processes and policy development.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="bg-gradient-to-br from-slate-600/20 to-gray-700/20 backdrop-blur-md border border-slate-600/30 hover:scale-105 transition-all duration-300 group">
                <CardContent className="p-6">
                  <div className="flex items-start space-x-4">
                    <div className="w-12 h-12 bg-gradient-to-br from-slate-600 to-gray-700 rounded-lg flex items-center justify-center flex-shrink-0 group-hover:scale-110 transition-transform duration-300">
                      <Lightbulb className="w-6 h-6 text-white" />
                    </div>
                    <div>
                      <h3 className="text-xl font-semibold text-white mb-2">Innovation Showcase</h3>
                      <p className="text-gray-300">
                        Present cutting-edge research and practical applications of AI in public sector transformation.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="bg-gradient-to-br from-gray-600/20 to-blue-700/20 backdrop-blur-md border border-slate-600/30 hover:scale-105 transition-all duration-300 group">
                <CardContent className="p-6">
                  <div className="flex items-start space-x-4">
                    <div className="w-12 h-12 bg-gradient-to-br from-gray-600 to-blue-700 rounded-lg flex items-center justify-center flex-shrink-0 group-hover:scale-110 transition-transform duration-300">
                      <Globe className="w-6 h-6 text-white" />
                    </div>
                    <div>
                      <h3 className="text-xl font-semibold text-white mb-2">Global Perspectives</h3>
                      <p className="text-gray-300">
                        Share international best practices and lessons learned from digital government initiatives worldwide.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="bg-gradient-to-br from-blue-700/20 to-slate-600/20 backdrop-blur-md border border-slate-600/30 hover:scale-105 transition-all duration-300 group">
                <CardContent className="p-6">
                  <div className="flex items-start space-x-4">
                    <div className="w-12 h-12 bg-gradient-to-br from-blue-700 to-slate-600 rounded-lg flex items-center justify-center flex-shrink-0 group-hover:scale-110 transition-transform duration-300">
                      <GraduationCap className="w-6 h-6 text-white" />
                    </div>
                    <div>
                      <h3 className="text-xl font-semibold text-white mb-2">Academic Collaboration</h3>
                      <p className="text-gray-300">
                        Foster partnerships between universities and government agencies for sustainable digital transformation.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>
            </div>
          </section>

          {/* Topics */}
          <section>
            <h2 className="text-4xl font-bold text-center text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-slate-400 mb-8">
              Conference Topics
            </h2>
            <Card className="bg-gradient-to-br from-slate-700/20 to-blue-800/20 backdrop-blur-md border border-slate-600/30">
              <CardContent className="p-8">
                <div className="grid md:grid-cols-2 gap-8">
                  <div className="space-y-6">
                    <div className="bg-white/10 rounded-lg p-6 hover:bg-white/15 transition-all duration-300">
                      <h3 className="text-xl font-semibold text-blue-400 mb-4 flex items-center gap-2">
                        <Users className="w-5 h-5" />
                        AI & Digital Governance
                      </h3>
                      <ul className="space-y-2 text-gray-300">
                        <li>• Machine Learning in Public Policy</li>
                        <li>• Predictive Analytics for Government</li>
                        <li>• AI Ethics in Public Sector</li>
                        <li>• Automated Decision Systems</li>
                      </ul>
                    </div>
                    
                    <div className="bg-white/10 rounded-lg p-6 hover:bg-white/15 transition-all duration-300">
                      <h3 className="text-xl font-semibold text-slate-400 mb-4 flex items-center gap-2">
                        <GraduationCap className="w-5 h-5" />
                        Higher Education Role
                      </h3>
                      <ul className="space-y-2 text-gray-300">
                        <li>• University-Government Partnerships</li>
                        <li>• Research Translation to Policy</li>
                        <li>• Capacity Building Programs</li>
                        <li>• Digital Skills Development</li>
                      </ul>
                    </div>
                  </div>
                  
                  <div className="space-y-6">
                    <div className="bg-white/10 rounded-lg p-6 hover:bg-white/15 transition-all duration-300">
                      <h3 className="text-xl font-semibold text-gray-400 mb-4 flex items-center gap-2">
                        <Building className="w-5 h-5" />
                        Digital Transformation
                      </h3>
                      <ul className="space-y-2 text-gray-300">
                        <li>• E-Government Services</li>
                        <li>• Digital Identity Systems</li>
                        <li>• Blockchain in Government</li>
                        <li>• Cybersecurity Frameworks</li>
                      </ul>
                    </div>
                    
                    <div className="bg-white/10 rounded-lg p-6 hover:bg-white/15 transition-all duration-300">
                      <h3 className="text-xl font-semibold text-blue-300 mb-4 flex items-center gap-2">
                        <TrendingUp className="w-5 h-5" />
                        Future Perspectives
                      </h3>
                      <ul className="space-y-2 text-gray-300">
                        <li>• Smart Cities Development</li>
                        <li>• Citizen Engagement Platforms</li>
                        <li>• Data-Driven Governance</li>
                        <li>• Sustainable Digital Solutions</li>
                      </ul>
                    </div>
                  </div>
                </div>
              </CardContent>
            </Card>
          </section>
        </div>
      </div>
    </div>
  );
}