import { Button } from '@/components/ui/button';
import { Card, CardContent } from '@/components/ui/card';
import { Calendar, MapPin, Users, FileText, Sparkles, Award, Building } from 'lucide-react';
import { Link } from 'react-router-dom';

export default function Index() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-slate-900 via-blue-900 to-gray-900 relative overflow-hidden">
      {/* Subtle animated background elements */}
      <div className="absolute inset-0 overflow-hidden">
        <div className="absolute -top-40 -right-40 w-80 h-80 bg-gradient-to-br from-blue-600/20 to-slate-600/20 rounded-full mix-blend-multiply filter blur-xl opacity-50 animate-pulse"></div>
        <div className="absolute -bottom-40 -left-40 w-80 h-80 bg-gradient-to-br from-gray-600/20 to-blue-600/20 rounded-full mix-blend-multiply filter blur-xl opacity-50 animate-pulse animation-delay-2000"></div>
        <div className="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-80 h-80 bg-gradient-to-br from-slate-600/20 to-gray-600/20 rounded-full mix-blend-multiply filter blur-xl opacity-50 animate-pulse animation-delay-4000"></div>
      </div>

      {/* Hero Section */}
      <section className="relative py-20 px-4 text-center">
        <div className="max-w-6xl mx-auto">
          {/* Professional badge */}
          <div className="absolute inset-0 pointer-events-none">
            <Award className="absolute top-20 left-10 w-6 h-6 text-blue-400/60 animate-pulse" />
            <Building className="absolute top-32 right-20 w-8 h-8 text-slate-400/60 animate-pulse" />
            <Sparkles className="absolute bottom-40 left-20 w-6 h-6 text-gray-400/60 animate-pulse" />
          </div>

          <div className="mb-8">
            <div className="inline-flex items-center px-6 py-3 bg-gradient-to-r from-blue-600 to-slate-700 rounded-full text-white text-sm font-medium mb-6 shadow-lg">
              <Calendar className="w-4 h-4 mr-2" />
              April 8-10, 2025 • South Africa
            </div>
            
            <h1 className="text-4xl md:text-7xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-blue-400 via-slate-300 to-gray-300 mb-6 leading-tight">
              Intelligence & Higher Education
              <span className="block text-3xl md:text-5xl mt-2 bg-gradient-to-r from-slate-400 to-blue-400 bg-clip-text text-transparent">
                Enabling Digital Government
              </span>
            </h1>
            
            <p className="text-xl md:text-2xl text-gray-300 mb-8 max-w-4xl mx-auto leading-relaxed">
              Join leading experts in exploring the intersection of <span className="text-blue-400 font-semibold">artificial intelligence</span>, 
              <span className="text-slate-300 font-semibold"> higher education</span>, and 
              <span className="text-gray-300 font-semibold"> digital governance</span>
            </p>
          </div>
          
          <div className="grid md:grid-cols-3 gap-6 mb-12 max-w-4xl mx-auto">
            <div className="flex items-center justify-center space-x-2 bg-white/10 backdrop-blur-md rounded-lg p-4 border border-slate-600/30">
              <Calendar className="w-6 h-6 text-blue-400" />
              <span className="font-semibold text-white">3 Days</span>
            </div>
            <div className="flex items-center justify-center space-x-2 bg-white/10 backdrop-blur-md rounded-lg p-4 border border-slate-600/30">
              <MapPin className="w-6 h-6 text-slate-400" />
              <span className="font-semibold text-white">South Africa</span>
            </div>
            <div className="flex items-center justify-center space-x-2 bg-white/10 backdrop-blur-md rounded-lg p-4 border border-slate-600/30">
              <Users className="w-6 h-6 text-gray-400" />
              <span className="font-semibold text-white">15 Expert Speakers</span>
            </div>
          </div>

          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button asChild size="lg" className="bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white font-semibold py-4 px-8 rounded-lg shadow-lg transform hover:scale-105 transition-all duration-300">
              <Link to="/register">Register Now</Link>
            </Button>
            <Button asChild variant="outline" size="lg" className="border-2 border-slate-400/50 text-slate-200 hover:bg-slate-700/50 backdrop-blur-md font-semibold py-4 px-8 rounded-lg shadow-lg transform hover:scale-105 transition-all duration-300">
              <Link to="/submit-paper">Submit Paper</Link>
            </Button>
          </div>
        </div>
      </section>

      {/* Key Features */}
      <section className="relative py-16 px-4">
        <div className="max-w-6xl mx-auto">
          <h2 className="text-4xl font-bold text-center text-transparent bg-clip-text bg-gradient-to-r from-slate-300 to-blue-400 mb-12">
            Conference Highlights
          </h2>
          <div className="grid md:grid-cols-3 gap-8">
            <Card className="bg-white/10 backdrop-blur-md border border-slate-600/30 hover:bg-white/15 transition-all duration-300 transform hover:scale-105 hover:-translate-y-2">
              <CardContent className="p-6 text-center">
                <div className="w-16 h-16 bg-gradient-to-br from-blue-600 to-slate-700 rounded-lg flex items-center justify-center mx-auto mb-4 shadow-lg">
                  <Users className="w-8 h-8 text-white" />
                </div>
                <h3 className="text-xl font-semibold text-white mb-2">Expert Speakers</h3>
                <p className="text-gray-300">15 renowned experts from academia, government, and industry sharing cutting-edge insights.</p>
              </CardContent>
            </Card>

            <Card className="bg-white/10 backdrop-blur-md border border-slate-600/30 hover:bg-white/15 transition-all duration-300 transform hover:scale-105 hover:-translate-y-2">
              <CardContent className="p-6 text-center">
                <div className="w-16 h-16 bg-gradient-to-br from-slate-600 to-gray-700 rounded-lg flex items-center justify-center mx-auto mb-4 shadow-lg">
                  <FileText className="w-8 h-8 text-white" />
                </div>
                <h3 className="text-xl font-semibold text-white mb-2">Research Papers</h3>
                <p className="text-gray-300">Submit groundbreaking research and contribute to digital governance advancement.</p>
              </CardContent>
            </Card>

            <Card className="bg-white/10 backdrop-blur-md border border-slate-600/30 hover:bg-white/15 transition-all duration-300 transform hover:scale-105 hover:-translate-y-2">
              <CardContent className="p-6 text-center">
                <div className="w-16 h-16 bg-gradient-to-br from-gray-600 to-blue-700 rounded-lg flex items-center justify-center mx-auto mb-4 shadow-lg">
                  <Calendar className="w-8 h-8 text-white" />
                </div>
                <h3 className="text-xl font-semibold text-white mb-2">Professional Program</h3>
                <p className="text-gray-300">Interactive sessions, workshops, and networking events designed for professionals.</p>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Call to Action */}
      <section className="relative py-16 px-4">
        <div className="max-w-4xl mx-auto text-center">
          <div className="bg-gradient-to-r from-slate-800/60 to-blue-800/60 backdrop-blur-md rounded-lg p-12 border border-slate-600/30">
            <h2 className="text-4xl font-bold mb-6 text-transparent bg-clip-text bg-gradient-to-r from-slate-200 to-blue-300">
              Shape the Digital Future
            </h2>
            <p className="text-xl mb-8 text-gray-300">
              Join industry leaders and academic experts in advancing digital governance through 
              <span className="text-blue-400 font-semibold"> intelligent solutions</span> and 
              <span className="text-slate-300 font-semibold"> educational partnerships</span>.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Button asChild size="lg" className="bg-gradient-to-r from-slate-600 to-gray-700 hover:from-slate-700 hover:to-gray-800 text-white font-semibold py-4 px-8 rounded-lg shadow-lg transform hover:scale-105 transition-all duration-300">
                <Link to="/about">Learn More</Link>
              </Button>
              <Button asChild size="lg" className="bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white font-semibold py-4 px-8 rounded-lg shadow-lg transform hover:scale-105 transition-all duration-300">
                <Link to="/speakers">View Speakers</Link>
              </Button>
            </div>
          </div>
        </div>
      </section>
    </div>
  );
}