import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Target, Lightbulb, Globe, GraduationCap, Rocket, Zap, Star, Sparkles } from 'lucide-react';

export default function About() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-purple-900 via-blue-900 to-indigo-900 py-12 px-4 relative overflow-hidden">
      {/* Animated background elements */}
      <div className="absolute inset-0">
        <div className="absolute top-20 left-10 w-72 h-72 bg-purple-500 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-pulse"></div>
        <div className="absolute top-40 right-10 w-72 h-72 bg-cyan-500 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-pulse animation-delay-2000"></div>
        <div className="absolute -bottom-8 left-20 w-72 h-72 bg-pink-500 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-pulse animation-delay-4000"></div>
      </div>

      <div className="max-w-6xl mx-auto relative">
        <div className="text-center mb-12">
          <div className="flex justify-center mb-6">
            <div className="relative">
              <Rocket className="w-16 h-16 text-cyan-400 animate-bounce" />
              <Sparkles className="w-8 h-8 text-yellow-400 absolute -top-2 -right-2 animate-pulse" />
            </div>
          </div>
          <h1 className="text-5xl font-bold bg-gradient-to-r from-cyan-400 via-purple-400 to-pink-400 bg-clip-text text-transparent mb-6">
            About the Conference
          </h1>
          <p className="text-xl text-gray-200 max-w-4xl mx-auto">
            🚀 Dive into the revolutionary intersection of AI, higher education, and digital governance! 
            This isn't just a conference - it's a launchpad for the future! ✨
          </p>
        </div>

        {/* Conference Theme */}
        <section className="mb-16">
          <Card className="bg-gradient-to-br from-purple-500/20 to-pink-500/20 backdrop-blur-sm border border-purple-400/30 hover:shadow-2xl transition-all duration-500">
            <CardHeader>
              <CardTitle className="text-3xl text-center bg-gradient-to-r from-yellow-400 to-orange-400 bg-clip-text text-transparent flex items-center justify-center gap-2">
                <Star className="w-8 h-8 text-yellow-400" />
                Conference Theme
                <Star className="w-8 h-8 text-yellow-400" />
              </CardTitle>
            </CardHeader>
            <CardContent className="text-center">
              <p className="text-lg text-gray-200 leading-relaxed">
                🌟 In an era of explosive digital transformation, governments worldwide are harnessing the power of 
                artificial intelligence and forging dynamic partnerships with higher education institutions to create 
                mind-blowing, efficient, transparent, and citizen-centric public services! 
                <br /><br />
                🎯 This electrifying conference brings together the brightest minds to explore how intelligent systems 
                and academic brilliance can supercharge the evolution of digital governance. Get ready to witness 
                the future unfold! 🚀
              </p>
            </CardContent>
          </Card>
        </section>

        {/* Key Objectives */}
        <section className="mb-16">
          <h2 className="text-4xl font-bold text-center bg-gradient-to-r from-cyan-400 to-purple-400 bg-clip-text text-transparent mb-8">
            🎯 Key Objectives
          </h2>
          <div className="grid md:grid-cols-2 gap-8">
            <Card className="bg-gradient-to-br from-cyan-500/20 to-blue-500/20 backdrop-blur-sm border border-cyan-400/30 hover:shadow-2xl hover:border-cyan-400/60 transition-all duration-500 transform hover:scale-105 hover:-translate-y-2">
              <CardContent className="p-6">
                <div className="flex items-start space-x-4">
                  <div className="w-12 h-12 bg-gradient-to-br from-cyan-400 to-blue-500 rounded-full flex items-center justify-center flex-shrink-0 shadow-lg">
                    <Target className="w-6 h-6 text-white" />
                  </div>
                  <div>
                    <h3 className="text-xl font-semibold text-cyan-300 mb-2">🎯 Strategic Insights</h3>
                    <p className="text-gray-300">
                      Unlock the secrets of how AI technologies can revolutionize government decision-making processes and supercharge policy development!
                    </p>
                  </div>
                </div>
              </CardContent>
            </Card>

            <Card className="bg-gradient-to-br from-yellow-500/20 to-orange-500/20 backdrop-blur-sm border border-yellow-400/30 hover:shadow-2xl hover:border-yellow-400/60 transition-all duration-500 transform hover:scale-105 hover:-translate-y-2">
              <CardContent className="p-6">
                <div className="flex items-start space-x-4">
                  <div className="w-12 h-12 bg-gradient-to-br from-yellow-400 to-orange-500 rounded-full flex items-center justify-center flex-shrink-0 shadow-lg">
                    <Lightbulb className="w-6 h-6 text-white" />
                  </div>
                  <div>
                    <h3 className="text-xl font-semibold text-yellow-300 mb-2">💡 Innovation Showcase</h3>
                    <p className="text-gray-300">
                      Witness mind-blowing cutting-edge research and game-changing practical applications of AI in public sector transformation!
                    </p>
                  </div>
                </div>
              </CardContent>
            </Card>

            <Card className="bg-gradient-to-br from-purple-500/20 to-pink-500/20 backdrop-blur-sm border border-purple-400/30 hover:shadow-2xl hover:border-purple-400/60 transition-all duration-500 transform hover:scale-105 hover:-translate-y-2">
              <CardContent className="p-6">
                <div className="flex items-start space-x-4">
                  <div className="w-12 h-12 bg-gradient-to-br from-purple-400 to-pink-500 rounded-full flex items-center justify-center flex-shrink-0 shadow-lg">
                    <Globe className="w-6 h-6 text-white" />
                  </div>
                  <div>
                    <h3 className="text-xl font-semibold text-purple-300 mb-2">🌍 Global Perspectives</h3>
                    <p className="text-gray-300">
                      Discover incredible international best practices and learn from epic success stories of digital government initiatives worldwide!
                    </p>
                  </div>
                </div>
              </CardContent>
            </Card>

            <Card className="bg-gradient-to-br from-green-500/20 to-teal-500/20 backdrop-blur-sm border border-green-400/30 hover:shadow-2xl hover:border-green-400/60 transition-all duration-500 transform hover:scale-105 hover:-translate-y-2">
              <CardContent className="p-6">
                <div className="flex items-start space-x-4">
                  <div className="w-12 h-12 bg-gradient-to-br from-green-400 to-teal-500 rounded-full flex items-center justify-center flex-shrink-0 shadow-lg">
                    <GraduationCap className="w-6 h-6 text-white" />
                  </div>
                  <div>
                    <h3 className="text-xl font-semibold text-green-300 mb-2">🎓 Academic Collaboration</h3>
                    <p className="text-gray-300">
                      Build powerful partnerships between universities and government agencies for sustainable digital transformation that changes the world!
                    </p>
                  </div>
                </div>
              </CardContent>
            </Card>
          </div>
        </section>

        {/* Topics */}
        <section>
          <h2 className="text-4xl font-bold text-center bg-gradient-to-r from-pink-400 to-purple-400 bg-clip-text text-transparent mb-8 flex items-center justify-center gap-2">
            <Zap className="w-8 h-8 text-pink-400" />
            Conference Topics
            <Zap className="w-8 h-8 text-pink-400" />
          </h2>
          <Card className="bg-gradient-to-br from-indigo-500/20 to-purple-500/20 backdrop-blur-sm border border-indigo-400/30 hover:shadow-2xl transition-all duration-500">
            <CardContent className="p-8">
              <div className="grid md:grid-cols-2 gap-8">
                <div className="space-y-6">
                  <div className="bg-gradient-to-r from-cyan-500/20 to-blue-500/20 p-6 rounded-xl border border-cyan-400/30">
                    <h3 className="text-xl font-semibold text-cyan-300 mb-4 flex items-center gap-2">
                      🤖 AI & Digital Governance
                    </h3>
                    <ul className="space-y-2 text-gray-300">
                      <li>• 🧠 Machine Learning in Public Policy</li>
                      <li>• 📊 Predictive Analytics for Government</li>
                      <li>• ⚖️ AI Ethics in Public Sector</li>
                      <li>• 🔄 Automated Decision Systems</li>
                    </ul>
                  </div>

                  <div className="bg-gradient-to-r from-purple-500/20 to-pink-500/20 p-6 rounded-xl border border-purple-400/30">
                    <h3 className="text-xl font-semibold text-purple-300 mb-4 flex items-center gap-2">
                      🎓 Higher Education Role
                    </h3>
                    <ul className="space-y-2 text-gray-300">
                      <li>• 🤝 University-Government Partnerships</li>
                      <li>• 🔬 Research Translation to Policy</li>
                      <li>• 💪 Capacity Building Programs</li>
                      <li>• 🚀 Digital Skills Development</li>
                    </ul>
                  </div>
                </div>

                <div className="space-y-6">
                  <div className="bg-gradient-to-r from-yellow-500/20 to-orange-500/20 p-6 rounded-xl border border-yellow-400/30">
                    <h3 className="text-xl font-semibold text-yellow-300 mb-4 flex items-center gap-2">
                      ⚡ Digital Transformation
                    </h3>
                    <ul className="space-y-2 text-gray-300">
                      <li>• 💻 E-Government Services</li>
                      <li>• 🆔 Digital Identity Systems</li>
                      <li>• ⛓️ Blockchain in Government</li>
                      <li>• 🛡️ Cybersecurity Frameworks</li>
                    </ul>
                  </div>

                  <div className="bg-gradient-to-r from-green-500/20 to-teal-500/20 p-6 rounded-xl border border-green-400/30">
                    <h3 className="text-xl font-semibold text-green-300 mb-4 flex items-center gap-2">
                      🔮 Future Perspectives
                    </h3>
                    <ul className="space-y-2 text-gray-300">
                      <li>• 🏙️ Smart Cities Development</li>
                      <li>• 👥 Citizen Engagement Platforms</li>
                      <li>• 📈 Data-Driven Governance</li>
                      <li>• 🌱 Sustainable Digital Solutions</li>
                    </ul>
                  </div>
                </div>
              </div>
            </CardContent>
          </Card>
        </section>
      </div>
    </div>
  );
}