import { Button } from '@/components/ui/button';
import { Card, CardContent } from '@/components/ui/card';
import { Calendar, MapPin, Users, FileText, Sparkles, Brain, Zap } from 'lucide-react';
import { Link } from 'react-router-dom';

export default function Index() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-purple-900 via-blue-900 to-indigo-900 relative overflow-hidden">
      {/* Animated background elements */}
      <div className="absolute inset-0">
        <div className="absolute top-20 left-10 w-72 h-72 bg-purple-500 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-pulse"></div>
        <div className="absolute top-40 right-10 w-72 h-72 bg-cyan-500 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-pulse animation-delay-2000"></div>
        <div className="absolute -bottom-8 left-20 w-72 h-72 bg-pink-500 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-pulse animation-delay-4000"></div>
      </div>

      {/* Hero Section */}
      <section className="relative py-20 px-4 text-center">
        <div className="max-w-6xl mx-auto">
          <div className="mb-8">
            <div className="flex justify-center mb-6">
              <div className="relative">
                <Brain className="w-16 h-16 text-cyan-400 animate-pulse" />
                <Sparkles className="w-8 h-8 text-yellow-400 absolute -top-2 -right-2 animate-bounce" />
              </div>
            </div>
            
            <h1 className="text-5xl md:text-7xl font-bold bg-gradient-to-r from-cyan-400 via-purple-400 to-pink-400 bg-clip-text text-transparent mb-6 leading-tight animate-in fade-in slide-in-from-bottom-8 duration-1000">
              Intelligence & Higher Education
            </h1>
            <h2 className="text-3xl md:text-4xl font-semibold text-white mb-8 animate-in fade-in slide-in-from-bottom-8 duration-1000 delay-300">
              Enabling Digital Government
            </h2>
            <p className="text-xl md:text-2xl text-gray-200 mb-8 max-w-4xl mx-auto animate-in fade-in slide-in-from-bottom-8 duration-1000 delay-500">
              🚀 Join the revolution where AI meets governance! Connect with visionary leaders reshaping the future of digital democracy.
            </p>
          </div>
          
          <div className="grid md:grid-cols-3 gap-6 mb-12 max-w-4xl mx-auto">
            <div className="flex items-center justify-center space-x-2 text-cyan-300 bg-white/10 backdrop-blur-sm rounded-full px-6 py-3 border border-cyan-400/30 hover:bg-white/20 transition-all duration-300">
              <Calendar className="w-6 h-6" />
              <span className="font-semibold">April 8-10, 2025</span>
            </div>
            <div className="flex items-center justify-center space-x-2 text-purple-300 bg-white/10 backdrop-blur-sm rounded-full px-6 py-3 border border-purple-400/30 hover:bg-white/20 transition-all duration-300">
              <MapPin className="w-6 h-6" />
              <span className="font-semibold">South Africa 🇿🇦</span>
            </div>
            <div className="flex items-center justify-center space-x-2 text-pink-300 bg-white/10 backdrop-blur-sm rounded-full px-6 py-3 border border-pink-400/30 hover:bg-white/20 transition-all duration-300">
              <Users className="w-6 h-6" />
              <span className="font-semibold">15 Visionary Speakers</span>
            </div>
          </div>

          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button asChild size="lg" className="bg-gradient-to-r from-cyan-500 to-blue-600 hover:from-cyan-600 hover:to-blue-700 text-white font-semibold px-8 py-4 rounded-full shadow-lg hover:shadow-xl transform hover:scale-105 transition-all duration-300">
              <Link to="/register">🎯 Register Now</Link>
            </Button>
            <Button asChild variant="outline" size="lg" className="border-2 border-purple-400 text-purple-300 hover:bg-purple-400 hover:text-white font-semibold px-8 py-4 rounded-full backdrop-blur-sm bg-white/10 shadow-lg hover:shadow-xl transform hover:scale-105 transition-all duration-300">
              <Link to="/submit-paper">📝 Submit Paper</Link>
            </Button>
          </div>
        </div>
      </section>

      {/* Key Features */}
      <section className="relative py-16 px-4">
        <div className="max-w-6xl mx-auto">
          <h2 className="text-4xl font-bold text-center bg-gradient-to-r from-yellow-400 to-orange-400 bg-clip-text text-transparent mb-12 animate-in fade-in duration-1000">
            ✨ Conference Highlights
          </h2>
          <div className="grid md:grid-cols-3 gap-8">
            <Card className="bg-gradient-to-br from-purple-500/20 to-pink-500/20 backdrop-blur-sm border border-purple-400/30 hover:border-purple-400/60 hover:shadow-2xl transform hover:scale-105 transition-all duration-500 hover:-translate-y-2">
              <CardContent className="p-6 text-center">
                <div className="w-16 h-16 bg-gradient-to-br from-purple-400 to-pink-400 rounded-full flex items-center justify-center mx-auto mb-4 shadow-lg">
                  <Users className="w-8 h-8 text-white" />
                </div>
                <h3 className="text-xl font-semibold text-purple-300 mb-2">🌟 Expert Speakers</h3>
                <p className="text-gray-300">15 renowned experts from academia, government, and industry sharing cutting-edge insights and revolutionary ideas.</p>
              </CardContent>
            </Card>

            <Card className="bg-gradient-to-br from-cyan-500/20 to-blue-500/20 backdrop-blur-sm border border-cyan-400/30 hover:border-cyan-400/60 hover:shadow-2xl transform hover:scale-105 transition-all duration-500 hover:-translate-y-2">
              <CardContent className="p-6 text-center">
                <div className="w-16 h-16 bg-gradient-to-br from-cyan-400 to-blue-400 rounded-full flex items-center justify-center mx-auto mb-4 shadow-lg">
                  <FileText className="w-8 h-8 text-white" />
                </div>
                <h3 className="text-xl font-semibold text-cyan-300 mb-2">🔬 Research Papers</h3>
                <p className="text-gray-300">Submit your groundbreaking research and contribute to the advancement of digital governance knowledge.</p>
              </CardContent>
            </Card>

            <Card className="bg-gradient-to-br from-yellow-500/20 to-orange-500/20 backdrop-blur-sm border border-yellow-400/30 hover:border-yellow-400/60 hover:shadow-2xl transform hover:scale-105 transition-all duration-500 hover:-translate-y-2">
              <CardContent className="p-6 text-center">
                <div className="w-16 h-16 bg-gradient-to-br from-yellow-400 to-orange-400 rounded-full flex items-center justify-center mx-auto mb-4 shadow-lg">
                  <Zap className="w-8 h-8 text-white" />
                </div>
                <h3 className="text-xl font-semibold text-yellow-300 mb-2">⚡ 3-Day Experience</h3>
                <p className="text-gray-300">Immersive sessions covering AI, digital transformation, and educational innovation that will blow your mind.</p>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Call to Action */}
      <section className="relative py-16 px-4">
        <div className="max-w-4xl mx-auto text-center">
          <div className="bg-gradient-to-r from-purple-600/30 to-pink-600/30 backdrop-blur-sm rounded-3xl p-12 border border-purple-400/30 shadow-2xl">
            <h2 className="text-4xl font-bold mb-6 bg-gradient-to-r from-white to-gray-200 bg-clip-text text-transparent">
              🚀 Be Part of the Digital Revolution
            </h2>
            <p className="text-xl mb-8 text-gray-200">
              Join us in shaping the future of digital government through intelligent higher education initiatives. 
              This is where tomorrow begins! 🌟
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Button asChild size="lg" className="bg-gradient-to-r from-yellow-400 to-orange-500 hover:from-yellow-500 hover:to-orange-600 text-black font-bold px-8 py-4 rounded-full shadow-lg hover:shadow-xl transform hover:scale-105 transition-all duration-300">
                <Link to="/about">🎯 Learn More</Link>
              </Button>
              <Button asChild size="lg" className="bg-gradient-to-r from-pink-500 to-purple-600 hover:from-pink-600 hover:to-purple-700 text-white font-bold px-8 py-4 rounded-full shadow-lg hover:shadow-xl transform hover:scale-105 transition-all duration-300">
                <Link to="/speakers">👥 Meet the Visionaries</Link>
              </Button>
            </div>
          </div>
        </div>
      </section>
    </div>
  );
}